	 function [b, a] = FLATDELAY(K, L, taug)
	
	 % Computes the transfer function of the allpole filter used
	 % in the function MAX_FLAT_WDF.m
	 
	% Reference
	%	I.W. Selesnick: Low-Pass Filters Realzable as All-Pass Sums: 
	%	Design via a New Flat Delay Filter, IEEE Trans. on Circuits 
	%	and Systems, Vol. 46, No. 1, pp. 40-50, Jan. 1999.
	
	%	K, L: Number of conditions at wT = 0 and  rad
	%	taug: group delay
	%	b/a: Allpole filter of degree N = K+L
	
	%	Example: 
	%   K = 6; L = 4; taug = 3.2;
	
	N = K+L;
	a = zeros(1, N+1);
	c = 1;
	for k = 0:L
		n = k:N-1;
		v = (n-N)./(n-k+1).*(2*taug+n+k)./(2*taug+N+1+n);
		a = a +[zeros(1,k), cumprod([c, v])];
		c = c*4*(taug+k)*(L-k)/(2*taug+N+k+1)/(k+1);
	end
	b = sum(a)
